import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gap/gap.dart';
import 'package:razinsoft_rider/core/extensions/extensions.dart';
import 'package:razinsoft_rider/core/utils/is_dark_mode.dart';
import 'package:razinsoft_rider/generated/l10n.dart';
import 'package:razinsoft_rider/presentation/track_order/widgets/cancel_ride_dialogue.dart';
import 'package:razinsoft_rider/presentation/track_order/widgets/show_order_location_detail_dialogue.dart';

import '../../../gen/assets.gen.dart';
import '../../waypoint/widgets/app_card_sheet.dart';

class LookingForDriverSheet extends StatelessWidget {
  const LookingForDriverSheet({super.key});

  @override
  Widget build(BuildContext context) => AppCardSheet(
      child: SafeArea(
        top: false,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          mainAxisSize: MainAxisSize.min,
          children: [

            Row(
              children: [
                Flexible(child: Column(
                  // mainAxisAlignment: MainAxisAlignment.end,
                  // crossAxisAlignment: CrossAxisAlignment.end,
                  children: [
                    Text(AppLocalizations.of(context).searching_for_driver, textAlign: TextAlign.center, style: context.bodyMedium?.copyWith(fontSize: 15.sp, fontWeight: FontWeight.w600, color: isDarkMode() ? Colors.white : Colors.black),),
                    Text(AppLocalizations.of(context).wait_message, textAlign: TextAlign.center, style: context.bodyMedium?.copyWith(fontSize: 12.sp, fontWeight: FontWeight.w400, color: isDarkMode() ? Colors.white54 : const Color(0xFF687387)),),

                  ],
                )),
                Gap(16.w),
                PopupMenuButton<String>(
                  icon: Icon(
                    Icons.more_vert,
                    color: isDarkMode() ? Colors.white : Colors.black,
                  ),
                  // shadowColor: Colors.black.withValues(alpha: 0.5),
                  style: ButtonStyle(
                    overlayColor: WidgetStatePropertyAll(Colors.black.withValues(alpha: 0.2)),
                  ),
                  onSelected: (value) {
                    if (value == 'cancel') {
                      cancelRideDialogue(context);
                    } else if (value == 'details') {
                      showOrderLocationDetailDialogue(context);
                    }
                  },
                  itemBuilder: (BuildContext context) => [

                    PopupMenuItem<String>(
                      value: 'details',
                      child: Text(AppLocalizations().view_details, style: context.bodyMedium?.copyWith(fontSize: 15.sp, fontWeight: FontWeight.w400, ),),
                    ),
                    PopupMenuItem<String>(
                      value: 'cancel',
                      child: Text(AppLocalizations().cancel_ride, style: context.bodyMedium?.copyWith(fontSize: 15.sp, fontWeight: FontWeight.w400, color: Colors.red),),
                    ),
                  ],
                )
              ],
            ),

            SizedBox(height: 16.h, width: double.infinity,),
            Assets.lottie.searchingDriver.image(
              height: 130,
              width: 130,
              fit: BoxFit.fill
            )

          ],
        ),
      ),
    );
}
